#
# 標準関数 par による作図デバイスの設定
# (標準パッケージ graphics のグラフ作成)
#

# (1) 作図領域の分割(引数 mfrow, mfcol) ---------

## (a) 作図領域の分割なしでグラフを配置
plot(rnorm(10), main = "plot")

## (b) 作図領域を2行3列に分割、横方向に配置
current_par <- 
  par(no.readonly = TRUE)　# パラメータ保存
par(mfrow = c(2,3)) 　　　 # 作図領域を分割     

plot(rnorm(10), main = "figure 1")
plot(rnorm(10), main = "figure 2")
plot(rnorm(10), main = "figure 3")
plot(rnorm(10), main = "figure 4")
plot(rnorm(10), main = "figure 5")
plot(rnorm(10), main = "figure 6")
 
par(current_par)    　　　 # パラメータ復元 

## (c) 作図領域を2行3列に分割、縦方向に配置
current_par <- 
  par(no.readonly = TRUE)  # パラメータ保存
par(mfcol = c(2,3))   　　 # 作画領域を分割

plot(rnorm(10), main = "figure 1")
plot(rnorm(10), main = "figure 2")
plot(rnorm(10), main = "figure 3")
plot(rnorm(10), main = "figure 4")
plot(rnorm(10), main = "figure 5")
plot(rnorm(10), main = "figure 6")

par(current_par)   　　　　# パラメータ復元


# (2) 作図する領域 -----------------------------
#     デバイス領域、作図領域、プロット領域

current_par <- 
  par(no.readonly = TRUE)　# パラメータ保存

par(oma = c(1,1,1,1))　    # 外側余白を行数で指定
par(mar = c(5,4,1,1))      # 余白を行数で指定
par(mfrow = c(2, 2)) 　    # 作図領域を分割

for (i in 1:4) {
  plot(rnorm(10))
  box(which = "figure")　　# 作図領域の枠を表示 
}

par(current_par)   　　　　#パラメータ復元


# (3) 余白、外側余白、軸------------------------

## (a) 既定値(デフォルト)の表示
par("mar")  　# 余白、行単位(下、左、上、右)
par("mai")  　# 余白、インチ単位
par("oma")  　# 外側余白、行数単位
par("omi")  　# 外側余白、インチ単位
par("omd")  　# 外側余白、0～1(左、右、上、下)

## (b) 余白
current_par <- 
  par(no.readonly = TRUE)　　# パラメータ保存
par(mfrow = c(2, 2)) 　　　　# 作画画面を分割

plot(rnorm(10), main = "mar=c(5,4,4,2)+0.1")
box(which = "figure")　      # (i) 既定値

par(mar = c(4, 4, 2, 1))
plot(rnorm(10), main = "mar=c(4, 4, 2, 1)")
box(which = "figure")        # (ii) 

par(mar = c(3, 3, 2, 1))
plot(rnorm(10), main = "mar=c(3, 3, 2, 1)")
box(which = "figure")        # (iii)

par(mar = c(1, 1, 1, 1))
plot(rnorm(10), main = "mar=c(1, 1, 1, 1)")
box(which = "figure")        # (iv) 

par(current_par)   　　　　  # パラメータ復元

## (c) 軸ラベル、目盛ラベル、軸線の位置
current_par <- 
  par(no.readonly = TRUE)　  # パラメータ保存
par(mfrow = c(2, 2)) 

plot(rnorm(10), main = "mgp=c(3, 1, 0)")
box(which = "figure")　      # (i) 既定値

par(mgp = c(2.5, 1, 0))
plot(rnorm(10), main = "mgp=c(2.5, 1, 0)")
box(which = "figure")        # (ii)

par(mgp = c(2, 1, 0))
plot(rnorm(10), main = "mgp=c(2, 1, 0)")
box(which = "figure")        # (iii)

par(mgp = c(3.5, 1.5, 0.5))
plot(rnorm(10), main = "mgp=c(3.5, 1.5, 0.5)")
box(which = "figure")        #(iv)

par(current_par)   　　　  　# パラメータ復元


# (4) 作画デバイスの初期化 ----------------------

dev.off() 　　　# グラフのファイル保存時に使用


# 以上 ------------------------------------------