#
# 標準パッケージ graphics の関数 plot による作図
# 人工データによるデモンストレーション
#

# (1) データ ------------------------------------

## (a) 数値ベクトル（x1,y1 に対応あり）
##  x1：説明変数、y1：目的変数、x1で昇順に並び替え
x1 <- c( 1, 3, 6, 7, 9, 10)
y1 <- c( 2, 4, 5, 4, 7, 11) 

## (b) データフレーム(grp, obs に対応あり)
##     grp：group(群),  obs：observation(観測値)
df <- data.frame(
  grp = factor(
    c("A1","A1","A1","A1","A1","A2","A2","A2","A2"),
    levels = c("A1", "A2")
    ),　
  obs = c(7, 5, 6, 10, 2,  12, 10, 5, 15)
  ) 
View(df)　                       

## (c) 因子ベクトルとテーブルオブジェクト
##     原因：Male/Female → 結果：yes/no、
gender <- factor(
  rep(c("male", "female"), times = c(4, 5)),
  levels = c("male", "female")
  )
answer <- factor(
  c("yes", "no",  "no", "yes",
    "no",  "no", "yes",  "no",  "no"),
  levels = c("no", "yes")
  )
tb <- table(gender, answer)
print(tb)


# (2) 余白の設定、軸の設定 ----------------------

par(mar = c(3, 4, 2, 2), mgp = c(1.5, 0.5, 0))
### mar(下余白, 左余白, 上余白, 右余白)、行単位
### mgp(軸～軸ラベル, 軸～目盛ラベル, 軸～軸線)


# (3) 関数 plot の典型的な使い方 ----------------

## (a) plot() の最もシンプルなコード
plot(x1, y1)         # 散布図、位置引数
plot(x = x1, y = y1) # 散布図、名前付き引数

## (b) 引数によるカスタマイズと低水準関数との組合せ
plot(                # 高水準関数、散布図
  x1, y1, 　　　　　 # 数値ベクトル(対応あり)
  xlim = c(0, 12),   # x 軸の範囲の指定
  ylim = c(0, 12),   # y 軸の範囲の指定
  main = "タイトル", # タイトルの追加
  xlab = "横軸",     # x軸の軸ラベルの追加
  ylab = "縦軸",     # y軸の軸ラベルの追加
  pch = 21,          # 記号の種類の指定
  col = "blue",      # 記号の色指定
  las = 1)           # 目盛ラベルの方向

lm_out <- lm(y1~x1)  # 回帰分析,線形モデルオブジェクト 

abline(lm_out,       # 低水準関数
       col = "blue") # 回帰直線の追加


# (4) 因子ベクトル 1 個 -------------------------

plot(answer)　　　　　　   # 棒グラフ 　

tb2 <- table(answer)       # テーブルオブジェクト
print(tb2)


# (5) 数値ベクトル 1 個：インデックスプロット----

plot(y1)               # 点グラフ("p",既定値)
plot(y1, type = "h")   # 棒グラフ(ヒストグラム風)
plot(y1, type = "l")   # 線グラフ
plot(y1, type = "c")   # 線グラフ(線分) 
plot(y1, type = "o")   # 線グラフ(点の上に線)
plot(y1, type = "b")   # 線グラフ(点と線分)
plot(y1, type = "s")   # 階段グラフ(水平→垂直)
plot(y1, type = "S")   # 階段グラフ(垂直→水平)
plot(y1, type = "n")   # プロットなし(枠のみ)


# (6) 因子ベクトル 2 個　------------------------

plot(gender, answer)    # (a)  スパインプロット
plot(answer ~ gender)   # (a') スパインプロット
　　　　　 # gender：説明変数、answer：応答変数

# (7) 数値ベクトル 2 個 -------------------------

plot(x1, y1)          　 # 散布図("p", 既定値)
plot(y1 ~ x1)            # 散布図

plot(x1, y1, type = "h") # 棒グラフ(ヒストグラム風)
plot(x1, y1, type = "l") # 線グラフ
plot(x1, y1, type = "c") # 線グラフ(線分) 
plot(x1, y1, type = "o") # 線グラフ(点の上に線)
plot(x1, y1, type = "b") # 線グラフ(点と線分)
plot(x1, y1, type = "s") # 階段グラフ(水平→垂直)
plot(x1, y1, type = "S") # 階段グラフ(垂直→水平)
plot(x1, y1, type = "n") # プロットなし


# (8) 因子ベクトル 1 個、数値ベクトル 1 個 ------

plot(obs ~ grp, data = df)   # (a) 箱ひげ図
plot(df$grp, df$obs)         # (a')箱ひげ図

plot(grp ~ obs, data = df)   # (b) スピノグラム

plot(df$obs, df$grp)　　　　 # (c) １次元散布図


# (9) 複数の数値ベクトル → データフレーム -------

yy1 <- c( 1, 3, 4, 5, 7,10)  # 対応のあるデータ
yy2 <- c(11,15,14,20,21,25)
yy3 <- c(12,10, 8, 5, 3, 3)
df3 <- data.frame(yy1, yy2, yy3)

plot(df3)                # 散布図行列


# (10) データフレーム ---------------------------

## (a) モザイク図、「データフレーム$列名」の利用
plot(df$grp, df$obs)         

## (b) モザイク図、関数 with() の利用
with(df, {               
  plot(grp, obs)
  abline(h = mean(obs), col = "red")  
})

with(df, plot(grp, obs))　   

## (c) モザイク図、引数 data の利用
plot(obs ~ grp, data = df)   


# (11) 時系列オブジェクト(ts型オブジェクト) -----

ts_out <- ts(c(5.2, 5.5, 7.3, 8.8, 10.7),
             start = c(2020, 1), frequency = 1)

plot(ts_out)             # 時系列グラフ


# (12) 線形モデルオブジェクト(lm型オブジェクト)--
#       （マルチパネル、ファセット）

lm_out <- lm(y1 ~ x1)    # 回帰分析

par(mfcol = c(2, 2))     # 作図画面を４分割
plot(lm_out)　　　　　　 # 回帰分析の残差診断図
par(mfrow = c(1, 1))     # 画面分割を復元


# (13) 関数オブジェクト(function型オブジェクト)--

## (a) 関数のグラフ、引数が１つのユーザー定義関数
mod_1 <- function(x) x * 5.2 + 1     

plot(mod_1 , from = 2, to= 8)

## (b) 関数のグラフ、引数が２つのユーザー定義関数
mod_2 <- function(x, a) x * (-5.2) + a

plot(function(x) mod_2(x, a = 1), 
     from = 2, to = 8)               


# (14) 分割表オブジェクト(table型オブジェクト)--

## (a)１つの因子ベクトルの集計(度数表)
tb3 <- table(answer)　　     # 分割表オブジェクト

print(tb3)   # 度数表（[Console]に出力）
plot(tb3)    # 棒グラフ

## (b) ２つの因子ベクトルの集計(分割表)
tb4 <- table(gender, answer) # 分割表オブジェクト

print(tb4)   # 分割表（[Console]に出力）
plot(tb4)    # モザイク図


# (15) 引数：xlim, ylim(軸の最小値と最大値) -----
#            xaxp, yaxp(目盛線の位置)

## (a) 軸の範囲(最小値,最大値)の設定,目盛線は自動
plot(
  x1, y1, 　　　      　　　　　　
  xlim = c(0, 16),    # x軸 c(最小値、最大値)
  ylim = c(0, 12))    # y軸 c(最小値、最大値)

## (b) 軸の範囲と目盛線の設定
plot(
  x1, y1,             
  xlim = c(0, 16), 
  xaxp = c(0, 16, 2), # c(最小値,最大値,区切り数)
  ylim = c(0, 12), 
  yaxp = c(0, 12, 4)) # c(最小値,最大値,区切り数)


# (16) 引数：xlab, ylab, main, sub, ann----------

## (a) xlab, ylab, main, sub の表示
plot(x1, y1,　　　　  # 散布図
     xlab = "x 軸ラベル", 
     ylab = "y 軸ラベル",
     main = "メインタイトル", 
     sub = "サブタイトル")

## (b) annにより非表示、代わりに低水準関数で表示
plot(x1, y1,
     ann = FALSE) 　　# main, xlab, ylab を非表示
title(　　　　　　　　# 低水準関数
  main = "カスタムタイトル", 
  xlab = "カスタムx軸ラベル", 
  ylab = "カスタムy軸ラベル")


# (17) 引数：log(常用対数の軸、表示上) ----------

plot(x1, y1, log = "y")   # x軸を常用対数スケール
plot(x1, y1, log = "x")   # y軸を常用対数スケール
plot(x1, y1, log = "xy")  # 両軸を常用対数スケール


# (18) 引数：axes, xaxt, yaxt, frame.plot -------

par(mfrow = c(2, 2))    　 # 作図画面を４分割

plot(x1, y1, axes = FALSE) # (a) 両軸と枠を非表示
plot(x1, y1, xaxt = "n")   # (b) x軸を非表示
plot(x1, y1, yaxt = "n")   # (c) y軸を非表示
plot(x1, y1, 
     frame.plot = FALSE)   # (d) 枠を非表示

par(mfrow = c(1, 1))       # 作図画面を復元


# (19) 引数：xaxt, yaxt -------------------------

par(mfrow = c(2, 2))    　 # 作図画面を４分割

plot(x1, y1, xaxs = "r")   # (a) 自動(規定値)
plot(x1, y1, xaxs = "i")   # (b) 軸の拡張なし
plot(x1, y1, yaxs = "r")   # (c) 自動(規定値)
plot(x1, y1, yaxs = "i")   # (d) 軸の拡張なし

par(mfrow = c(1, 1))       # 作図画面を復元


# (20) 引数：asp(アスペクト比) ------------------

par(mfrow = c(2, 2))    # 作図画面を４分割

x_coords <- c(2, 2, 10, 10, 2)
y_coords <- c(2, 10, 10, 2, 2)

plot(x1, y1, asp = NA)  # (a) 自動 (規定値)
lines(x_coords, y_coords, col = "red")

plot(x1, y1, asp = 1) 　# (b) x軸1単位＝y軸1単位
lines(x_coords, y_coords, col = "red")

plot(x1, y1, asp = 2)　 # (c) y軸/x軸=2
lines(x_coords, y_coords, col = "red")

plot(x1, y1,asp = 0.5)  # (d) y軸/x軸=0.5
lines(x_coords, y_coords, col = "red")

par(mfrow = c(1, 1))    # 作図画面を復元


# (21)　グラフィックスパラメータ-----------------

## (a) 引数：pch(記号の形状)
plot(x1, y1, 
     xlim = c(0, 6), ylim = c(0, 6),
     xaxt = "n", yaxt = "n", type = "n",
     xlab = "", ylab = "", bty = "n")
points(1, 0, pch = 46, cex = 1.5)
text(1, 0, labels = 0, pos = 3 )
for (j in 1:5) {
  for (i in 1:5) {
    pch_num <- i + (j - 1) * 5　# 形状を指定
    points(i, j, pch = pch_num, cex = 1.5)
    text(i, j, labels = pch_num, pos = 3 )
  }
}

### pch =  0～14：引数 col で枠線の色指定
### pch = 15～20：引数 col で塗りつぶし、枠線なし
### pch = 21～25：引数 bg で背景色（塗りつぶし）
###               引数 col で枠線の色指定
###               引数 lwd で枠線の太さを指定

## (b) 引数：col, bg(色、背景色)
plot(x1, y1, type = "n",
     xlim = c(0, 5), ylim = c(0, 6),
     xlab = "x", ylab = "y")

par(cex = 2)
points(1, 1, pch = 21, bg = "black")
points(2, 1, pch = 21, bg = "white")
points(3, 1, pch = 21, bg = "red")
points(4, 1, pch = 21, bg = "green")
points(1, 2, pch = 21, bg = "blue")
points(2, 2, pch = 21, bg = "yellow")
points(3, 2, pch = 21, bg = "cyan")
points(4, 2, pch = 21, bg = "magenta")
points(1, 3, pch = 21, bg = "gray")
points(2, 3, pch = 21, bg = "lightgray")
points(3, 3, pch = 21, bg = "darkgray")
points(4, 3, pch = 21, bg = "orange")
points(1, 4, pch = 21, bg = "pink")
points(2, 4, pch = 21, bg = "purple")
points(3, 4, pch = 21, bg = "brown")
points(4, 4, pch = 21, bg = "beige")
points(1, 5, pch = 21, bg = "darkred")
points(2, 5, pch = 21, bg = "darkgreen")
points(3, 5, pch = 21, bg = "lightblue")
points(4, 5, pch = 21, bg = "lightgreen")
par(cex = 1)

colors()   # 色の名称を表示

## (c) 引数：lty(線種)、lwd(線の太さ)
plot(x1, y1, 
     xlab = "線の太さ(1.0,1.5,2.0,2.5,3.0,3.5)",
     ylab = "", type = "n", yaxt = "n", xaxt = "n",
     xlim = c(0, 6), ylim = c(0, 6))

abline(h = 1, lwd = 1.0, lty = "solid")
abline(h = 2, lwd = 1.5, lty = "dashed")
abline(h = 3, lwd = 2.0, lty = "dotted")
abline(h = 4, lwd = 2.5, lty = "dotdash")
abline(h = 5, lwd = 3.0, lty = "longdash")
abline(h = 6, lwd = 3.5, lty = "twodash")

axis(side = 2, 　　　　　# 左(y軸)を指定
     at = 0:6,           # x座標の位置
     labels = c(
       "0 : blank","1 : solid","2 : dashed",
       "3 : dotted", "4 : dotdash", 
       "5 : longdash", "6 : twodash"),
     las = 2, cex.axis = 0.8)

## (d) 引数：font(テキストのフォント)
plot(x1, y1, 
     xlab = "フォントの種類と番号",
     ylab = "",
     xlim = c(0, 6), ylim = c(0, 5),
     type = "n", yaxt = "n", xaxt = "n")

text(3, 1, label = "1:plain(default)", font = 1)
text(3, 2, label = "2:bold", font = 2)
text(3, 3, label = "3:italic", font = 3)
text(3, 4, label = "4:bold italic", font = 4)


# (22) 低水準関数：points, matpoints(点) --------

## (a) １点の追加
plot(x1, y1)　　　　　　 # 散布図
points(x = mean(x1),     # 重心の計算
       y = mean(y1),     # 重心の計算
       pch = 21, 　　　  # 記号の形状
       bg = "red",       # 記号の塗りつぶし
       col = "green",    # 記号の枠の色
       cex = 1.5,        # 記号サイズ
       lwd = 1.2)        # 記号の枠の太さ

## (b)　複数点の追加(線の追加)
plot(x1, y1)　　　　　　 # 散布図
points(x = c(4, 6, 8),   # x 座標
       y = c(6, 8, 9),   # y 座標
       type = "o",       # 点の上に線   
       col = "blue")     # 点と線の色

## (c) 複数系列の点の追加 
xx  <- c(1, 2, 4, 5, 7)
yy1 <- c(2, 3, 4, 6, 8)
yy2 <- c(1, 2, 3, 5, 7)

### (c-1) points() による点の追加
plot(NA, xlim = c(0, 7), ylim = c(1, 8),
     xlab = "x", ylab = "y")
points(xx, yy1, col = "blue", pch = 1)
points(xx, yy2, col = "red", pch = 2)

### (c-2) matpoints() による点の追加
yy <- cbind(yy1, yy2)
plot(NA, xlim = c(0, 7), ylim = c(1, 8),
     xlab = "x", ylab = "y")
matpoints(xx, yy, 
          pch = 1:2, col = c("blue", "red"))


# (23) 低水準関数：lines, matlines (直線)--------

## (a) 折れ線の追加
x2 <- c(4, 6, 10)　　 　    # 追加するx座標　
y2 <- c(2, 5,  6)           # 追加するy座標

plot(x1, y1,
     xlab = "x", ylab= "y") # 散布図
lines(x2, y2,         　    # 座標を線で連結
      lty = "solid",        # 線種
      lwd = 2,              # 線の太さ
      col = "red",          # 線の色
      lend = "butt",　　    # 線の端点の形状
      ljoin = "bevel")      # 線の結合部の形状 

## (b) 複数系列の折れ線の追加 
xx1 <- c(1, 2, 3, 5, 6)　   # 系列1 のx座標
yy1 <- c(3, 5, 6, 8, 7)　   # 系列1 のy座標
xx2 <- c(0, 2, 3, 4, 6)　   # 系列2 のx座標
yy2 <- c(1, 2, 4, 3, 5)　   # 系列2 のy座標

### (b-1) lines() による折れ線の追加
plot(x = NA, xlim = c(0,6), ylim= c(0, 10))
lines(xx1, yy1, col = "blue", lty = 1)
lines(xx2, yy2, col = "red", lty = 2)

### (b-2) matlines() による折れ線の追加
xx <- cbind(xx1, xx2)
yy <- cbind(yy1, yy2)
plot(x = NA, xlim = c(0,6), ylim= c(0, 10))
matlines(xx, yy, 
         lty = 1:2, col = c("blue", "red"))


# (24) 低水準関数 segments(線分) ----------------

## (a) １本の線分を表示
plot(x1, y1)　　　　　　 # 散布図
segments(x0 = 4, y0 = 3, # 線分の始点の座標 
         x1 = 8, y1 = 6, # 線分の終点の座標
         col = "green")

## (b) 複数の線分を同時に表示
xx0 <- c(1, 1, 1); yy0 <- c(1, 2, 3)
xx1 <- c(4, 4, 4); yy1 <- c(1, 2, 3)

plot(NA, xlab = "x", ylab = "y", 
     xlim = c(0, 5), ylim = c(0, 5))
segments(xx0, yy0, xx1, yy1, 
         col = c("red", "blue", "darkgreen"), 
         lwd = 2)

## (c) エラーバーを表示
### 事前に標準偏差、標準誤差などを計算、err に付値
err <- c(0.28, 0.42, 0.53, 0.54, 0.71, 0.89)

### エラーバー付の散布図
plot(x1, y1, pch = 16, ylim = c(0, 8))
segments(x1, (y1 + err), x1, (y1 - err), lwd = 2)


# (25) 低水準関数：arrows(矢印) -----------------

## (a) 矢印を追加
plot(x1, y1)
arrows(x0 = 4, y0 = 4, # 線分の始点の座標
       x1 = 8, y1 = 7, # 線分の終点の座標
       length = 0.1,   # 矢印の先端の長さ
       code = 2,       # 1,2:片矢印,3:両矢印
       col = "green")

## (b) エラーバーを表示
err <- c(0.28, 0.42, 0.53, 0.54, 0.71, 0.89)

plot(x1, y1, pch = 16, ylim = c(0, 8))
arrows(x1, (y1 - err), x1, (y1 + err),
       angle = 90, 　　# 軸と先端の角度
       length = 0.05,  # 矢印の先端の長さ
       code = 3)       # 両矢印


# (26) 低水準関数：abline(直線) -----------------

plot(x1, y1, xlim = c(0,12), ylim = c(0, 12))

abline(h = mean(y1),　 　# (a) 水平線を追加　　
       v = mean(x1),   　# (b) 垂直線を追加
       col = "green")   

abline(a = 8, b = 0.5,   # (c) 直線を追加
       col = "black")    #      y = a + bx

abline(coef = c(9, -2),  # (d) 直線を追加  
       col = "blue")     #　　　y = 9 - 2x

lm_out <- lm(y1 ~ x1)          
abline(reg = lm_out,     # (e) 回帰直線を追加
       col = "red") 


# (27) 高水準関数 curve(曲線) -------------------

plot(x1, y1,
     xlim = c(0,12), ylim = c(0, 12))　 
curve(expr = 0.1 * x^2,  # 関数の数式
      n = 101,           # xの範囲内での点数
      col = "red",       # 　 　(↑既定値101)
      add = TRUE)        # 高水準関数で上書き


# (28) 低水準関数：polygon(多角形) --------------

plot(x1, y1)                # 散布図
polygon(x = c(4, 4, 8, 8),  # x座標
        y = c(2, 8, 10, 2),  # y座標
        border = "red",
        lty = "solid")


# (29) 低水準関数：box(領域の枠線) --------------

current_par <- 
  par(no.readonly = TRUE)  # パラメータ保存

par(oma = c(1,1,1,1))　    # 外側余白を行数で指定
par(mar = c(5,4,1,1))      # 余白を行数で指定
par(mfrow = c(2, 2)) 　    # 作図領域を分割

for (i in 1:4) {　　　　
  plot(x1, y1, 
       frame.plot = FALSE) # 散布図、枠を非表示
}

box(which = "plot")        # (a) プロット領域
box(which = "figure")      # (b) 作図領域
box(which = "inner")       # (c) 作図領域の集合
box(which = "outer")       # (d) デバイス領域

par(current_par)   　　　　# パラメータ復元


# (30) 低水準関数：text(テキスト) ---------------

## (a) 文字の追加
m_x <- mean(x1); m_y <- mean(y1)

plot(x1, y1)          # 散布図  
points(m_x, m_y, col = "red")
text(
  x = m_x,            # 重心の x 座標
  y = m_y,            # 重心の y 座標
  labels = "重心",    # 表示する文字
  pos = 3,            # 下(1),左(2),上(3),右(4) 
  adj = 0.5,　　　　  # 中央に位置、0(左)～1(右)
  cex = 1.5)          # テキストの表示倍率

## (b) 複数個所での文字の追加
plot(x1, y1, ylim = c(0,12))  
text(
  x = x1,             
  y = y1,             
  labels = c("a1","a2","a3","a4","a5","a6"),
  pos = 3,             
  adj = 0.5,    
  cex = 0.8)    

## (c) 記号にラベルを自動生成して表示
plot(x1, y1, ylim = c(0,12), xlim = c(0, 12))  
text(
  x = x1,             
  y = y1,             
  labels = paste("a", 1:6, sep = ""),
  pos = 3, cex = 0.8)  

## (d) 記号にデータの数値を表示
num <- round(y1, 1)   # 四捨五入
plot(x1, y1, ylim = c(0,12), xlim = c(0, 12))  
text(
  x = x1,             
  y = y1,             
  labels = format(num, nsmall = 1),
  pos = 3, cex = 0.8)  


# (31) 低水準関数：mtext(余白のテキスト) --------

## (a) グラフの下部余白に注釈を追加
current_par <- 
  par(no.readonly=TRUE)   # パラメータ保存
par(mar = c(5, 4, 1, 1))　# 余白を行数で指定

plot(x1, y1)　　　 # 散布図
tx <- "注釈 \n これは注釈です"　# \n：改行
mtext(
  text = tx,　     # 表示する文字
  side = 1,   　   # 下(1),左(2),上(3),右(4)
  line = 3,        # プロット領域からの行数
  adj = 0,   　    # 揃え位置、0:左or下,1:右or上
  cex = 0.8)　　   # テキストの表示倍率

par(current_par)   　　　# パラメータ復元

## (b) 複数のグラフに対して全体のタイトルを付ける
##     （マルチパネル、ファセット）
current_par <- 
  par(no.readonly=TRUE)  # パラメータ保存

par(mar = c(5,4,1,1))    # 全体のタイトル用の余白
par(mfrow = c(1, 2))     # 作図領域を分割

plot(x1, y1)　　    　   # 散布図-１　
plot(x1, y1)             # 散布図-２

mtext(
  text ="タイトル",　    # 全体のタイトルの文字
  side = 1,   　         # 表示位置
  line = 3,              # プロット領域からの行数
  at   = -4.5,　　　         # 右の図からの位置
  cex  = 1.3)　　         # 全体のタイトルの倍率

par(current_par)   　　　# パラメータ復元


# (32) 低水準関数：title（タイトル）-------------

current_par <- 
  par(no.readonly = TRUE) # パラメータ保存
par(mar = c(4,4,3,1)) 

plot(x1, y1, 　　　　　　 # 散布図　　
     main = "", xlab = "", ylab = "")

title(main = "追加のメインタイトル",
      xlab = "追加のx軸ラベル ",
      ylab = "追加のy軸ラベル",
      font.lab = 2,       # ラベルのフォント指定
      cex.lab = 0.8,　　  # ラベルのサイズ指定
      col.lab = "red",    # ラベルの色指定
      col.main = "blue",  # タイトルの色指定
      line = 2)           # 軸からの距離(行数)

par(current_par)   　　　 # パラメータ復元


# (33) 低水準関数：legend(凡例) -----------------

## (a) 2 系列(2グループ)を表示(1)
###系統1： x1, y1、系統2：x2, y2
x2 <- c(1, 4, 6, 8, 11) 
y2 <- c(5, 6, 9, 11, 14)
  
plot(x1, y1,             # 散布図、系列１
     xlim = c(0, 12), ylim = c(0, 15),
     pch = 16,
     col = "blue")

points(x2, y2, 　　　　  # 散布図、系列２
       pch = 17,         
       col = "red")

legend(x = 0, y= 15,     # 凡例を追加
       title =  "群",
       legend = c("A1", "A2"),
       col = c("blue", "red"),      
       pch = c(16, 17),
       cex = 0.8)             

## (b) 関数 locator() の利用
plot(x1, y1,         # 散布図、系列１
     xlim = c(0, 12),
     ylim = c(0, 20),
     col = "blue")

points(x2, y2, 　　 # 散布図、系列２
       pch = 17,    # 659～660行目でデータを設定済
       col = "red")

pos <- locator(1)   # 凡例の位置となる＋をクリック

legend(pos,         # 凡例を表示
       title =  "群",
       legend = c("A1", "A2"),
       col = c("blue", "red"),      
       pch = c(16, 17),
       cex = 0.8)      

print(pos)  # 得られた値を690行目のposと書換　


# (34) 低水準関数：axis(x軸, y軸の調整) -------------

## (a) x軸の座標 1～5 に A～E を割付
plot(y1,                 # 散布図、x軸は行番号     
     xlim = c(1, 5), 　  # 座標：1,2,3,4,5
     xaxt = "n",         # x軸の非表示
     xlab = "")          # x軸ラベルの非表示
     
axis(side = 1,           # 1:下,2:左,3:上,4:右 
     at = 1:5,           # x座標の位置
     labels = c("A", "B", "C", "D", "E"))

## (b) x軸の位置1,3,5に0,2,4を割付、目盛線を追加
plot(x1, y1,           　# 散布図
     xlim = c(0, 10),　  # x座標の範囲 
     xaxt = "n",         # x軸の非表示
     xlab = "")　　　　　# x軸ラベルの非表示

axis(side = 1, 　　　　　# 下(x軸)を指定
     at = 0:10, 　  　   # x座標の位置
     labels = FALSE)　   # 目盛線のみを表示

axis(side = 1, 　　　　　# 下(x軸)を指定
     at = c(0,5,10),     # x座標の位置
     labels = c(0,5,10)) # x軸の目盛ラベルを表示

## (c) x軸の位置 1～5 までに、x1～x9 を割付
plot(y1, 　　　　　　　　# 散布図 x軸は行番号
     xlim = c(1, 5),
     xaxt = "n",　　　　 # x軸の非表示
     xlab = "")　　　　　# x軸ラベルの非表示

axis(side = 1, 　　　　　# 下(x軸)を指定
     at = 1:5, 
     labels = paste0("X", seq(1, 9, 2)))

## (d) 軸(x軸またはy軸)の位置を指定
lm_out <- lm(y1 ~ x1)　　# 回帰分析

plot(x1, y1, 　　　　　　# 散布図
     xlim = c(-5, 15),   # x軸の範囲を負まで拡大
     ylim = c(-5, 20),   # y軸の範囲を負まで拡大
     axes = FALSE)　　　 # 軸を非表示

axis(side = 1, pos = 0)  # x軸を y=0 の位置に設置
axis(side = 2, pos = 0)  # y軸を x=0 の位置に設置

abline(lm_out)           # 回帰直線を追加


# (35) 低水準関数：grid(グリッド線) -------------

## (a) 自動設定
plot(x1, y1)　　　　　　 # 散布図
grid()          　　　　 # 引数を省略、自動設定

## (b) グリッドの水平線と垂直線の選択
plot(x1, y1)　　　　　　 # 散布図
grid(nx = NA,　　        # 垂直線は非表示 
     ny = NULL,          # 水平線は自動設定
     col = "gray",　     # グリット線の色
     lty = "solid",      # グリッド線の形状
     lwd = 1.5)　　　　  # グリッド線の太さ

## (c) 対数目盛のグリッド線
plot(8:270, log="xy")    # 対数目盛
grid(equilogs = FALSE) 


# (36) 複数系列(複数グループ)を複数パネルで表示--
#       （マルチパネル、ファセット）

par(mfrow = c(1, 2))　　 # 作図領域を縦に2分割

plot(x1, y1, 　　　　　　# 散布図-１
     xlim = c(0, 12), 
     ylim = c(0, 16),
     main = "Group 1", 
     col = "orange")
plot(x2, y2,             # 散布図-２
     xlim = c(0, 12), 
     ylim = c(0, 16),
     main = "Group 2", 
     col = "blue")

par(mfrow = c(1, 1))     # 作図領域を復元


# 以上 ------------------------------------------